import { login, logout, generateCsvIndex } from "./indiceService.js";

(async () => {
  try {
    const nodeId = process.env.ALFRESCO_NODEID;
    const username = process.env.ALFRESCO_USERNAME;
    const password = process.env.ALFRESCO_PASSWORD;

    if (!nodeId || !username || !password) {
      throw new Error("Faltan definir variables.");
    }

    await login(username, password);
    await generateCsvIndex(nodeId, "./indice.csv");
    console.log("Generacion de indice completado.");
  } catch (error) {
    console.error("Error en el proceso:", error);
  } finally {
    await logout();
  }
})();
