package pe.com.domain.webscript;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

import pe.com.domain.service.WatermarkService;

public class PdfWebScript extends AbstractWebScript {

    private static Log LOG = LogFactory.getLog(PdfWebScript.class);

    private ContentService contentService;
    private WatermarkService watermarkService;

    @Override
    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        Map<String, String> templateArgs = req.getServiceMatch().getTemplateVars();
        String uuid = templateArgs.get("uuid");

        String watermarkText = req.getParameter("text");

        NodeRef nodeRef = new NodeRef("workspace://SpacesStore/" + uuid);

        ContentReader reader = contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
        InputStream nodeInputStream = reader.getContentInputStream();

        watermarkService.addWatermark(watermarkText, nodeInputStream, res.getOutputStream());
        res.setContentType("application/pdf");
        res.setContentEncoding("UTF-8");
        res.addHeader("Content-Disposition", "attachment; filename=watermarked_pdf.pdf");
    }
        
    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setWatermarkService(WatermarkService watermarkService) {
        this.watermarkService = watermarkService;
    }

}
