package pe.com.domain.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.poi.ss.usermodel.Color;



//SE COLOCA LA MARCA DE AGUA EN EL PDF QUE ES SELECCIONADO
// URL:  http://localhost:8080/alfresco/service/watermark/ACÁ SE COLOCA EL URL?text=Action
public class WatermarkService {

    public WatermarkService() {}

    public void addWatermark(String watermarkText, InputStream is, OutputStream os) throws IOException {
        try (PDDocument document = PDDocument.load(is)) {
            for (int i = 0; i < document.getNumberOfPages(); i++) {
                PDPage page = document.getPage(i);
                
                try (PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true)) {
                    contentStream.beginText();
                    contentStream.setFont(PDType1Font.HELVETICA_BOLD, 40);

                    // Establecer color de relleno (color rojo)
                    PDColor nonStrokingColor = new PDColor(new float[]{1, 0, 0}, PDDeviceRGB.INSTANCE);
                    contentStream.setNonStrokingColor(nonStrokingColor);

                    // Establecer color de contorno (color rojo)
                    PDColor strokingColor = new PDColor(new float[]{1, 0, 0}, PDDeviceRGB.INSTANCE);
                    contentStream.setStrokingColor(strokingColor);


                    // Calcula el ancho y alto de la página
                    PDRectangle mediaBox = page.getMediaBox();
                    float pageWidth = mediaBox.getWidth();
                    float pageHeight = mediaBox.getHeight();

                    // Calcula la posición del texto en el centro
                    float textWidth = PDType1Font.HELVETICA_BOLD.getStringWidth(watermarkText) / 1000 * 40;
                    float textHeight = 40;
                    float textX = (pageWidth - textWidth) / 2;
                    float textY = (pageHeight - textHeight) / 2;

                    contentStream.newLineAtOffset(textX, textY);
                    contentStream.showText(watermarkText);
                    contentStream.endText();
                }
            }
            document.save(os);
        }
    }
}