package pe.com.domain.webscript;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.alfresco.jlan.client.info.FileInfo;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;

public class PdfWebScript extends DeclarativeWebScript {

    private static Log LOG = LogFactory.getLog(PdfWebScript.class);
    private FileFolderService fileFolderService;
    private NodeService nodeService;
    private NodeRef actionedUponNodeRef;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    private void addWatermark(NodeRef ubicacionPdf, OutputStream outputStream) throws IOException {
       
        String watermarkText = "CONFIDENCIAL"; // Texto de la marca de agua
        //Se carga el documento PDF desde la ubicación especificada por ubicacionPdf
        try (PDDocument document = PDDocument.load(new File(nodeService.getPath(ubicacionPdf).toString()))) {
            //itera cada una de las páginas
            for (int i = 0; i < document.getNumberOfPages(); i++) {
                //SE OBTIENE REFERENCIA A LA PÁGINA i
                PDPage page = document.getPage(i);
                //Para escribir contenido en la página actual del documento PDF.
                try (PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true)) {
                    contentStream.beginText();
                    contentStream.setFont(PDType1Font.HELVETICA_BOLD, 40);
                    contentStream.setNonStrokingColor(java.awt.Color.BLACK);
                    contentStream.setStrokingColor(java.awt.Color.RED);
                    contentStream.newLineAtOffset(100, 100); 
                    contentStream.showText(watermarkText);
                    contentStream.showText(watermarkText);
                    contentStream.endText();
                }
            }
            document.save(outputStream);
        }
    }

   
    protected Map<String, Object> executeImpl(WebScriptRequest req, WebScriptResponse res) throws IOException {
        LOG.info("Se ejecutó la acción");
        LOG.debug("Se ejecutó la acción");
        Map<String, Object> model = new HashMap<>();
        try {
            Map<String, String> templateArgs = req.getServiceMatch().getTemplateVars();
            String uuid = templateArgs.get("uuid");
            NodeRef ubicacionPdf = new NodeRef("workspace://SpacesStore/" + uuid);
            

        model.put("name", "Leonardo");
        model.put("nodeName", "1234");

            // Crear un flujo de salida para escribir la marca de agua
            
            //ByteArrayOutputStream baos = new ByteArrayOutputStream();
           
            LOG.info("SE ESTÁ AGREGANDO");
            // Configurar la respuesta HTTP
            res.setContentType("application/pdf");
            res.setContentEncoding("UTF-8");
            res.addHeader("Content-Disposition", "attachment; filename=watermarked_pdf.pdf");
            //Pazo el flujo de datos de la respuesta 
            addWatermark(ubicacionPdf, res.getOutputStream()); 
            // Escribir la marca de agua en el flujo de salida de la respuesta
            //res.getOutputStream().write(baos.toByteArray());
            //res.getOutputStream().flush();
        } catch (IOException e) {

            LOG.error("Error al agregar marca de agua al PDF: " + e.getMessage(), e);
            throw new WebScriptException(Status.STATUS_INTERNAL_SERVER_ERROR, "Error al agregar marca de agua al PDF", e);
        } finally {
            // Cerrar el flujo de salida después de escribir en él
            if (res.getOutputStream() != null) {
                try {
                    res.getOutputStream().close();
                } catch (IOException ioEx) {
                    LOG.error("Error al cerrar el flujo de salida: " + ioEx.getMessage(), ioEx);
                }
            }
        }
        
        model.put("bytes", "bytes".getBytes());
        return model;
        
    }


    //ACÁ YA SE REALIZÓ LA ACCIÓN CORRESPONDIENTE DE LA MARCA DE AGUA
    //UBICACIÓN Y MARCA DE AGUA
    //outputStream se recibirá la marca de agua con marca de agua
    
}
